% Matlab program to draw phase diagrams in the baseline Diamond overlapping generations model.
% By Marc P. B. Klemp, November 2009.

function v = v(c)
global h m Util_type;

if Util_type == 1                          % This is the CRRA utility function
    if m == 1
        for i = 1:length(c)
            if c(i) > 0
                v(i) = log(c(i));
            else
                v(i) = NaN;
            end
        end
    else
        v = (c.^(1-m))/(1-m);
    end

elseif Util_type == 2
    if m == 1
        for i = 1:length(c)
            if c(i)-h > 0
                v(i) = log(c(i)-h);
            else
                v(i) = NaN;
            end
        end
    else
        v = ((c-h).^(1-m))/(1-m);
    end


elseif Util_type == 3                      % This is the CARA utility function. Paired with the CES production function, the model is able to generate
    v = -exp(-m*c);                        % multiple intertemporal equilibria. However, this utility function does not satisfy the "no fast"-
                                           % assumption of the textbook.

elseif Util_type == 4                      % To comply with the "no fast"-assumption, we "paste" the function -1/c together with -exp(-c)
    for i = 1:length(c)                    % The instantaneous utility function is required to be differentiable. We therefore solve the equation
        if c(i) < 0.7034674224             % (-1/c)' = (-exp(-c))' <=> ln(c) = c to paste the functions together at a point, where their slope are
            v(i) = -1/c(i);                % equal. Solved numerically, we get with the precision of 10 decimals c = 0.7034674224.
        else
            v(i) = -exp(-m*c(i));
        end
    end
end